/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.common.util.Box3;
import ht.treechop.common.util.Vector3;
import java.util.EnumMap;
import net.minecraft.util.Direction;

public enum FaceShape {
    DOWN(Direction.DOWN, new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 1.0), new Vector3(0.0, 0.0, 1.0)),
    UP(Direction.UP, new Vector3(0.0, 1.0, 0.0), new Vector3(1.0, 1.0, 0.0), new Vector3(1.0, 1.0, 1.0), new Vector3(0.0, 1.0, 1.0)),
    NORTH(Direction.NORTH, new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0), new Vector3(1.0, 1.0, 0.0), new Vector3(0.0, 1.0, 0.0)),
    SOUTH(Direction.SOUTH, new Vector3(0.0, 0.0, 1.0), new Vector3(1.0, 0.0, 1.0), new Vector3(1.0, 1.0, 1.0), new Vector3(0.0, 1.0, 1.0)),
    WEST(Direction.WEST, new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 1.0, 1.0), new Vector3(0.0, 0.0, 1.0)),
    EAST(Direction.EAST, new Vector3(1.0, 0.0, 0.0), new Vector3(1.0, 1.0, 0.0), new Vector3(1.0, 1.0, 1.0), new Vector3(1.0, 0.0, 1.0));

    private final Box3 faceBox;
    private final Direction direction;
    private static final EnumMap<Direction, FaceShape> fromDirections;
    private final Vector3 corner1;
    private final Vector3 corner3;
    private final Vector3 corner4;
    private final Vector3 corner2;

    private FaceShape(Direction direction, Vector3 corner1, Vector3 corner2, Vector3 corner3, Vector3 corner4) {
        this.direction = direction;
        Vector3 depthVector = new Vector3(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e()).scale(-0.01);
        Vector3 pushedCorner1 = corner1.add(depthVector);
        this.faceBox = new Box3(pushedCorner1, corner3);
        this.corner1 = corner1.scale(16.0);
        this.corner2 = corner2.scale(16.0);
        this.corner3 = corner3.scale(16.0);
        this.corner4 = corner4.scale(16.0);
    }

    public static FaceShape get(Direction direction) {
        return fromDirections.get(direction);
    }

    public Box3 getBox() {
        return this.faceBox;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Vector3 getCorner1() {
        return this.corner1;
    }

    public Vector3 getCorner3() {
        return this.corner3;
    }

    public Vector3 getCorner4() {
        return this.corner4;
    }

    public Vector3 getCorner2() {
        return this.corner2;
    }

    static {
        fromDirections = new EnumMap(Direction.class);
        fromDirections.put(Direction.DOWN, DOWN);
        fromDirections.put(Direction.UP, UP);
        fromDirections.put(Direction.NORTH, NORTH);
        fromDirections.put(Direction.SOUTH, SOUTH);
        fromDirections.put(Direction.WEST, WEST);
        fromDirections.put(Direction.EAST, EAST);
    }
}

